# 3. 开发您的应用程序服务

按照上述流程输入相关信息后，在进行测试和提交审核之前，您需要开发您的应用程序服务。它通过一系列API与Shoplazza进行交互。

## 获取Shoplazza API授权

### 概述

公共应用使用OAuth 2.0进行授权，交互过程如下图所示。

> 您需要注意第2、3、4、7、8、9步，然后您需要在第3、4、9步中编写您的处理逻辑代码。

> ⚠️ **警告：** authorization_code只能使用一次。

## 重要步骤详细信息

### 第2步：Shoplazza后端通过APP URL建立通信和授权

商家从[APP Store](https://appstore.shoplazza.com/)添加应用后，Shoplazza服务将通过[合作伙伴中心](https://partners.shoplazza.com/)配置的APP URL发送请求。

例如：
```
https://stamped-review.apps.shoplazza.com/api/auth?hmac=c4caf9b08bdeff7531bb12712ffea860264ec24f5fd953832505c5024d19edca&install_from=app_store&shop=rwerwre.myshoplaza.com&store_id=1339409
```

格式为：
```
app_url?hmac=${hmac}&install_from=app_store&shop=${store_domain_name}&store_id=${store_id}
```

### 第3步：APP服务进行安全检查

在继续之前，请确保您的应用执行以下安全检查。如果任何检查失败，那么您的应用必须拒绝请求并返回错误，且不得继续执行。

- hmac是有效的，并且由Shoplazza签名
- shop参数是有效的商店主机名，以myshoplaza.com结尾

对于安全检查，[SHOPLAZZA OAuth SDKs](https://www.shoplazza.dev/reference/api-libraries)也有相应的方法。您可以通过SHOPLAZZA OAuth SDKs快速验证hmac和shop参数。

**使用OAuth-SDK-Go的示例：**
```go
import (
  co "github.com/shoplazza-os/oauth-sdk-go"
  "github.com/shoplazza-os/oauth-sdk-go/shoplazza"
)

oauth := &co.Config{
                ClientID:     "s1Ip1WxpoEAHtPPzGiP2rK2Az-P07Nie7V97hRKigl4",
                ClientSecret: "0LFJcNqVb2Z1nVt9xT72vOo0sTWd6j8wVX60Y5xdzZZ",
                Endpoint:     shoplazza.Endpoint,
                RedirectURI:  "https://3830-43-230-206-233.ngrok.io/oauth_sdk/redirect_uri/",
                Scopes:       []string{"read_shop"},
        }
oauth.ValidShop("xxx.myshoplaza.com")        // 验证shop参数

var requestUrl = "http://example.com/some/redirect_uri?code={authorization_code}&shop={store_name}.myshoplaza.com&hmac={hmac}"
query := strings.Split(requestUrl, "?")
params, _ := url.ParseQuery(query[1])
oauth.SignatureValid(params)                 // 验证hmac
```

#### HMac验证详情

Shoplazza到您的应用服务器的每个请求或重定向都包含一个hmac参数，可用于验证Shoplazza的真实性。对于每个请求，您必须从查询字符串中删除hmac条目，并通过**HMAC-SHA256**哈希函数处理它。

例如，对于以下请求：
```
http://example.com/some/redirect/uri?code=1vtke5ljOOL2jPds6gM0TNCeYZDitYB&shop=simon.myshoplaza.com&hmac=22bad22eee1f92836f7773e87d973479
```

要删除hmac，您可以将查询字符串转换为map，删除hmac键值对，然后按字典顺序将您的map重新连接为查询字符串。这保留了示例查询字符串中的剩余参数：
```
code=1vtke5ljOOL2jPds6gM0TNCeYZDitYB&shop=simon.myshoplaza.com
```

##### 处理哈希函数

删除hmac并重新格式化查询字符串后，您可以使用**Client secret**作为密钥，通过HMAC-SHA256哈希函数处理该字符串。

### 第4步：传递Scopes以获得访问所需API的权限

应用程序服务接收此授权请求。如果授权没有问题，它将使用302方法进行重定向。

例如：
```
https://rwerwre.myshoplaza.com/admin/oauth/authorize?client_id=ZwwR8eXIOq0Rr2XN3zUywxc0q-S9C3w4VkH3HnNUL_Q&redirect_uri=https%3A%2F%2Fstamped-review.apps.shoplazza.com%2Fapi%2Fauth%2Fcallback&response_type=code&scope=read_product+read_order+read_collection+read_shop+read_script_tags+write_script_tags+read_customer+read_price_rules+read_comments
```

格式：
```
https://${store_domain_name}/admin/oauth/authorize?client_id={client_id}&scope={scopes}&redirect_uri={redirect_uri}&response_type={response_type}&state={state}
```

参数：
- `store_domain_name`: `${store_name}.myshoplaza.com`
- `store_name`: 商家商店的名称
- `client_id`: 应用的Client ID。您可以在https://partners.shoplazza.com/注册应用后获取
- `scope`: [作用域]的空格分隔列表
- `redirect_uri`: 商家授权应用后重定向到的URL
- `response_type`: OAuth 2.0流程的响应类型，这里我们需要填写`code`
- `state`: 随机值，用于防止CSRF攻击

#### Scopes

Scope表示公共应用需要请求的权限，不同的权限允许访问不同的API。**scope的值由开发者选择并组装**到上面提到的302重定向URL中。在商家应用安装确认页面上，将要求商家授权所需的权限。

### 第7步：通过Code获取Access_token

您可以通过以下请求获取Access token：
```
POST https://{store_name}.myshoplaza.com/admin/oauth/token
```

在此请求中，`store_name`是商家商店的名称，以及以下参数：

- `client_id`: 应用的Client ID
- `client_secret`: 应用的Client secret密钥
- `code`: 重定向中提供的authorization_code
- `grant_type`: OAuth 2.0流程的授权类型，请在此处填写`authorization_code`
- `redirect_uri`: 应用的redirect_uri

服务器响应访问令牌：

```json
{
  "token_type": "Bearer",
  "expires_at": 1550546245,
  "access_token": "eyJ0eXAiOiJKV1QiLCJh",
  "refresh_token": "def502003d28ba08a964e",
  "store_id": "2",
  "store_name": "xiong1889"
}
```

响应参数：
- `token_type`: 只会返回Bearer
- `expires_at`: access_token过期时间，时间戳格式
- `access_token`: 正确的access_token
- `refresh_token`: 用于在需要时刷新access_token的刷新令牌
- `store_id`: Shoplazza中的商店ID
- `store_name`: 商店名称

> **OAuth SDK可用！**<br>
同样，您可以通过SHOPLAZZA OAuth SDKs快速获取访问令牌。

**使用OAuth-SDK-Go的示例：**
```go
token, err := oauth.Exchange("xxx")
if err != nil {
    // 处理错误
}
fmt.Println(token.AccessToken)
```

## 进行API调用

获得访问令牌后，您可以使用它对Shoplazza进行API调用。在API请求的Authorization头部中包含访问令牌：

```
Authorization: Bearer {access_token}
```

使用访问令牌访问与您在授权过程中请求的作用域相对应的API。